/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.comm;

import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.comm.SerialPortDataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.CommunicationSettingPanel;
import DE.siemens.ad.logo.dialog.comp.ConfirmIPPanel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.hardware.Unknown;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.IPV4Utils;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;

public abstract class DataTransfer {
    protected boolean fDebugComm = false;
    protected boolean fDebugGeneral = false;
    private static int callReadTime = 0;
    volatile long lastActionTime = 0L;
    private boolean fShowErrorDialog = true;
    private static final String LOG_DIRECTION_OUT = "PC --> ";
    private static final String LOG_DIRECTION_IN = "PC <-- ";
    ProgressListener fProgressListener = null;
    protected InputStream fInputStream = null;
    protected OutputStream fOutputStream = null;
    private long fLastSimulationTelegramReadTime;
    public static final String PORT_TYPE = "PortTypeSelection";
    public static final String SOCKET_TYPE = "Socket";
    public static final String SERIAL_PORT_TYPE = "SerialPortType";
    private static final int PC_WRITE_BYTE = 1;
    private static final int PC_READ_BYTE = 2;
    private static final int LOGO_READ_BYTE = 3;
    private static final int PC_WRITE_BYTES = 4;
    private static final int PC_READ_BYTES = 5;
    private static final int PC_ONLINE_TEST_TELEGRAM = 17;
    private static final int PC_REQUEST_PROGRAM_LINE = 19;
    private static final int PC_COMMAND_STATE_REQ = 23;
    private static final int PC_COMMAND_IO_REQ = 25;
    public static final int PC_PARAM_CHANGE_REQ = 26;
    private static final int PC_COMMAND_GET_HARDWARE_ID = 33;
    public static final int PC_COMMAND_CLEAR_PROG = 32;
    public static final int PC_COMMAND_RESTART_BM = 34;
    public static final int PC_COMMAND_IP_RECONFIGURED = 35;
    public static final int PC_COMMAND_DOWNLOAD_TO_SD_CARD = 36;
    protected static final int PC_COMMAND_UPLOAD_DATALOG = 37;
    public static final int PC_COMMAND_BM_MODE_RESTART = 38;
    public static final int PC_STOP_ONLINE_TEST = 20;
    public static final int PC_COMMAND_CHANGE_STATE_TO_STOP = 18;
    public static final int PC_COMMAND_CHANGE_STATE_TO_RUN = 24;
    private static final int PC_COMMAND_UPLOAD_DIAG_DATA = 27;
    private static final int PC_COMMAND_CLEAR_DIAG_DATA = 28;
    private static final int PC_COMMAND_DATA_TABLE_WRITE_REQUEST = 29;
    private static final int PC_COMMAND_DATA_TABLE_READ_REQUEST = 30;
    protected static final int ACK = 6;
    protected static final int NACK = 21;
    protected static final int START_BYTE = 85;
    protected static final int STOP_BYTE = 170;
    private static final int ERROR_BUSY = 1;
    private static final int ERROR_TIMEOUT = 2;
    protected static final int ERROR_ILLEGAL_ACCESS = 3;
    private static final int ERROR_PARITY = 4;
    private static final int ERROR_UNKNOWN_CMD = 5;
    private static final int ERROR_XOR_NOT_OK = 6;
    private static final int ERROR_SIMULATE = 7;
    private static final int ERROR_COPY_SD_CARD = 8;
    public static final int ERROR_INTERNAL = 128;
    public static final int ERROR_COMPORT_NOT_AVAILABLE = 176;
    public static final int ERROR_MODEM_NOT_AVAILABLE = 177;
    public static final int ERROR_RCV_BUFFER_EMPTY = 240;
    public static final int ERROR_CHECKSUM = 241;
    public static final int ERROR_NO_BLOCKTITLE_READ = 242;
    public static final int ERROR_HEAD_WRONG_ADRESS = 243;
    public static final int ERROR_UNKNOWN = 254;
    public static final int ERROR_NO_STREAM = 255;
    public static final int ERROR_READ_TIMEOUT = 244;
    public static final int TS_RUN = 1;
    public static final int TS_STOP = 2;
    public static final int TS_PARAM_MESSAGE = 4;
    public static final int TS_ERROR = 8;
    public static final int TS_ATTEMPT = 16;
    public static final int TS_PARAM = 32;
    public static final int TS_REMOTE = 64;
    public static final int TS_FIRST_CYCLE = 128;
    protected static final int CMD_HARDWARE_ID = 7938;
    int fLastAddress;
    boolean fAddressMode32 = true;
    int fByteCount = 0;
    byte[] fTelegramBuffer = new byte[1024];
    int fActTelePosition = 0;
    int fMaxTelePosition = 0;
    boolean fBlockMode = false;
    static DataTransfer cPort = null;
    private Hardware fRemoteHardware = null;
    public static final int STANDARD_TIMEOUT = 1001;

    protected DataTransfer() {
        callReadTime = 0;
    }

    public abstract void closePort();

    public abstract String toString();

    protected abstract void resetInternalWait();

    protected abstract int getReadByteRetryTimes();

    protected int getTimeoutRead(int estimatedTimeout) {
        return estimatedTimeout;
    }

    public static DataTransfer openConnection(boolean showError) throws ExceptionAlreadyHandledException {
        String portName;
        String portType = LogoProperties.instance().getProperty(PORT_TYPE, SERIAL_PORT_TYPE);
        if (portType.equals(SERIAL_PORT_TYPE)) {
            portName = LogoProperties.instance().getProperty("port", "COM2");
        } else if (LogoProperties.instance().getBooleanProperty("ConfirmIPAddressBeforeComm", true)) {
            ConfirmIPPanel panel = new ConfirmIPPanel(false);
            SplittedDlg dlg = SplittedDlg.create(null, panel, 3);
            dlg.show();
            if (dlg.getControlPanel().getResult() != 1) {
                throw new ExceptionAlreadyHandledException();
            }
            portName = panel.getIPAddress();
        } else {
            portName = LogoProperties.instance().getProperty("LOGOIpAddress", "192.168.1.1");
        }
        return DataTransfer.openConnection(portType, portName, showError, false);
    }

    public static DataTransfer openConnection(String portType, String portName, boolean showError, boolean ignoreDevice) throws ExceptionAlreadyHandledException {
        if (SOCKET_TYPE.equals(portType)) {
            return TcpSocketDataTransfer.openConnection(portName, showError, ignoreDevice);
        }
        return SerialPortDataTransfer.openConnection(portName, showError, ignoreDevice);
    }

    public boolean isTransmissionPossible(Component component) {
        try {
            Hardware hw = this.getHardware();
            if (hw.supports("transmissionPossible")) {
                int deviceState = this.getDeviceState();
                if (deviceState == 1 || deviceState == 32) {
                    int rv = JOptionPane.showConfirmDialog(component, Language.getString("error.com.deviceInRun", "Change to STOP?"), Language.getString("hardware.family.name", "Device"), 0);
                    if (rv == 0) {
                        this.sendStateCommand(18);
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hardware getHardware() {
        if (this.fRemoteHardware == null) {
            try {
                this.fRemoteHardware = this.getRemoteHardware();
            }
            catch (ExceptionAlreadyHandledException e) {
                this.fRemoteHardware = new Unknown();
            }
        }
        return this.fRemoteHardware;
    }

    protected void setHardware(Hardware newHardware) {
        this.fRemoteHardware = newHardware;
    }

    public void reConnect() throws ExceptionAlreadyHandledException {
        long time = System.currentTimeMillis();
        if (System.getProperty("os.name").equals("Mac OS X")) {
            while (System.currentTimeMillis() <= time + 800L) {
            }
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fRemoteHardware = this.getRemoteHardware();
        this.fBlockMode = this.fRemoteHardware.supports("blockmode");
    }

    protected int uploadHardwareID() throws TransmissionFailedException {
        boolean MAX_RETRY = true;
        int currentTry = 0;
        try {
            while (currentTry < 2) {
                this.resetInternalWait();
                this.writeToOutputStream(33);
                int readValue = this.readInternalByte();
                if (readValue == 6) {
                    this.fAddressMode32 = true;
                    if (this.readInternalByte() == 3) {
                        this.readInternalByte();
                        return this.readInternalByte();
                    }
                    ++currentTry;
                    continue;
                }
                if (readValue == 21) {
                    this.fAddressMode32 = false;
                    readValue = this.readNoWait();
                    if (readValue == 5) {
                        return this.readByte(7938) & 0xFF;
                    }
                    ++currentTry;
                    continue;
                }
                this.fAddressMode32 = false;
                ++currentTry;
            }
            throw new TransmissionFailedException(240);
        }
        catch (TransmissionFailedException e) {
            this.fAddressMode32 = false;
            if (e.getError() == 244) {
                int ret = this.readByte(7938) & 0xFF;
                return ret;
            }
            throw e;
        }
        catch (IOException exception) {
            throw new TransmissionFailedException(254);
        }
    }

    public int[] uploadDiagnosticData() throws TransmissionFailedException {
        if (this.sendStateCommand(27)) {
            this.readInternalByte();
            int[] ret = new int[4];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.readInternalByte();
            }
            return ret;
        }
        if (this.fDebugGeneral) {
            System.out.println("DataTransfer.uploadDiagnosticData() error.");
        }
        return null;
    }

    protected Hardware getRemoteHardware() throws ExceptionAlreadyHandledException {
        Hardware retValue = null;
        int remoteHardwareID = 0;
        boolean tryAgain = false;
        do {
            tryAgain = false;
            try {
                remoteHardwareID = this.uploadHardwareID();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.resetInternal();
            }
            catch (TransmissionFailedException tfe) {
                System.out.println("getRemoteHardware failed.");
                if (this.fShowErrorDialog) {
                    tryAgain = LogoError.checkRepeatTransmission(tfe);
                    if (tryAgain) continue;
                    throw new ExceptionAlreadyHandledException();
                }
                throw new ExceptionAlreadyHandledException();
            }
        } while (tryAgain);
        retValue = LogoHardwareFactory.getInstance().getHardware(remoteHardwareID);
        if (retValue instanceof Unknown) {
            if (this.fShowErrorDialog) {
                new LogoError(Language.getString("error.needNewerVersion", "You need a newer version of this program")).display();
            }
            throw new ExceptionAlreadyHandledException();
        }
        if (this.fDebugGeneral) {
            System.out.println("remote hardware: " + ((Object)retValue).toString());
        }
        return retValue;
    }

    protected final void nextAddress() {
        ++this.fLastAddress;
    }

    public int readByte(int adr) throws TransmissionFailedException {
        int MAX_RETRY = 5;
        int currentTry = 0;
        try {
            if (this.fInputStream != null && this.fOutputStream != null) {
                int readValue;
                this.fLastAddress = adr;
                while (true) {
                    this.resetInternal();
                    this.writeToOutputStream(2);
                    this.writeCommandAddress(adr);
                    readValue = this.readInternalByte();
                    if (readValue == 6) {
                        readValue = this.readInternalByte();
                        if (readValue != 3) {
                            if (++currentTry != MAX_RETRY) continue;
                            throw new TransmissionFailedException(242);
                        }
                        if (!this.checkCommandAddressFeedback(adr)) {
                            if (++currentTry != MAX_RETRY) continue;
                            throw new TransmissionFailedException(243);
                        }
                        readValue = this.readInternalByte();
                        ++this.fByteCount;
                        this.checkListener();
                        return readValue;
                    }
                    if (++currentTry > MAX_RETRY) break;
                }
                if (readValue == 21) {
                    readValue = this.readNoWait();
                }
                throw new TransmissionFailedException(readValue);
            }
            throw new TransmissionFailedException(255);
        }
        catch (IOException ioe) {
            throw new TransmissionFailedException(255);
        }
    }

    public int readNextByte() throws TransmissionFailedException {
        this.nextAddress();
        return this.readByte(this.fLastAddress);
    }

    public int[] readByteArray(int adr, int count) throws TransmissionFailedException {
        int retries = 0;
        int[] byteArray = null;
        int MAX_RETRY = this.getReadByteRetryTimes();
        if (count <= 2) {
            System.err.println("Read byte array should with the count > 2, otherwise error can not check");
        }
        while (true) {
            try {
                byteArray = null;
                if (this.fBlockMode) {
                    this.fByteCount += count / 2;
                    this.checkListener();
                    if (count < this.maxBytesInOneTelegram()) {
                        byteArray = this.readBytes(adr, count);
                    } else {
                        int curCount;
                        byteArray = new int[count];
                        for (int i = 0; i < count; i += curCount) {
                            curCount = Math.min(this.maxBytesInOneTelegram(), count - i);
                            int[] tempArray = this.readBytes(adr + i, curCount);
                            System.arraycopy(tempArray, 0, byteArray, i, tempArray.length);
                        }
                    }
                    this.fByteCount += count / 2;
                    this.checkListener();
                    break;
                }
                if (count <= 0) break;
                byteArray = new int[count];
                byteArray[0] = this.readByte(adr);
                for (int i = 1; i < count; ++i) {
                    byteArray[i] = this.readNextByte();
                }
            }
            catch (TransmissionFailedException e) {
                if (retries == MAX_RETRY) {
                    throw e;
                }
                ++retries;
                if (this.fDebugComm) {
                    System.err.println("readByteArray - Retries: " + retries);
                }
                System.out.println("Error read: " + e.getError());
                continue;
            }
            break;
        }
        return byteArray;
    }

    protected int maxBytesInOneTelegram() {
        return Integer.MAX_VALUE;
    }

    protected int[] readBytes(int adr, int count) throws TransmissionFailedException {
        if (this.fDebugComm) {
            System.out.println("array read: " + System.currentTimeMillis() + " " + Integer.toHexString(adr) + ", " + callReadTime++ + ", " + count);
        }
        int[] retValue = new int[count];
        int checksum = 0;
        try {
            if (this.fInputStream != null && this.fOutputStream != null) {
                this.resetInternal();
                this.writeToOutputStream(5);
                int readValue = this.noAckInBlockMode() ? 6 : this.readInternalByte();
                if (readValue == 6) {
                    this.writeCommandAddress(adr);
                    this.writeToOutputStream((byte)((count & 0xFF00) >> 8));
                    this.writeToOutputStream((byte)(count & 0xFF));
                    for (int i = 0; i < count; ++i) {
                        readValue = this.readInternalByteSafe();
                        if (readValue == -1) {
                            int error = 240;
                            if (i > 1 && retValue[i - 2] == 21) {
                                error = retValue[i - 1];
                            }
                            throw new TransmissionFailedException(error);
                        }
                        retValue[i] = readValue;
                        checksum ^= readValue;
                    }
                    if (checksum != this.readInternalByte()) {
                        throw new TransmissionFailedException(241);
                    }
                    this.fLastAddress = adr + count - 1;
                    return retValue;
                }
                if (readValue == 21) {
                    readValue = this.readNoWait();
                }
                throw new TransmissionFailedException(readValue);
            }
            throw new TransmissionFailedException(255);
        }
        catch (IOException ioe) {
            throw new TransmissionFailedException(255);
        }
    }

    protected int readInternalByte() throws TransmissionFailedException {
        return this.readInternalByte(this.getStandardTimeOut());
    }

    protected int readInternalByteSafe() {
        try {
            return this.readInternalByte();
        }
        catch (TransmissionFailedException e) {
            return -1;
        }
    }

    protected int readInternalByte(int timeout) throws TransmissionFailedException {
        int ret = this.readInternalByteWithTimeout(this.getTimeoutRead(timeout));
        if (this.fDebugComm && ret == -1 && timeout != 0) {
            System.out.println("readInternalByte() Error");
        }
        return ret;
    }

    protected int readNoWait() {
        try {
            return this.readInternalByteWithTimeout(0);
        }
        catch (Exception e) {
            return 254;
        }
    }

    private int readInternalByteWithTimeout(int timeout) throws TransmissionFailedException {
        int readValue = -1;
        if (this.fActTelePosition < this.fMaxTelePosition) {
            readValue = this.fTelegramBuffer[this.fActTelePosition];
            if (readValue < 0) {
                readValue += 256;
            }
            ++this.fActTelePosition;
            if (this.fDebugComm) {
                this.logInput(readValue);
            }
            return readValue;
        }
        try {
            block14: {
                long startTime;
                long pre_printTime = startTime = System.currentTimeMillis();
                while (this.fInputStream != null) {
                    this.fMaxTelePosition = this.readInputStream(this.fTelegramBuffer);
                    if (this.fMaxTelePosition > 0) {
                        this.fActTelePosition = 1;
                        readValue = this.fTelegramBuffer[0];
                        if (readValue < 0) {
                            readValue += 256;
                        }
                        if (this.fDebugComm) {
                            this.logInput(readValue);
                        }
                        break block14;
                    }
                    if (System.currentTimeMillis() - startTime > (long)timeout) {
                        if (timeout != 0) {
                            if (this.fDebugGeneral) {
                                System.out.println("read time out at: " + System.currentTimeMillis());
                            }
                            throw new TransmissionFailedException(244);
                        }
                        return -1;
                    }
                    if (System.currentTimeMillis() - pre_printTime < 1000L) continue;
                    if (this.fDebugComm) {
                        System.out.println("======Waiting for reading byte======");
                    }
                    pre_printTime = System.currentTimeMillis();
                }
                return -1;
            }
            return readValue;
        }
        catch (IOException ioe) {
            if (this.fDebugGeneral) {
                System.out.println("readInternalByte error: " + ioe.getMessage());
            }
            this.disablePortByNullPoint(ioe.getMessage());
            throw new TransmissionFailedException(240);
        }
    }

    protected int readInputStream(byte[] b) throws IOException {
        return this.fInputStream.read(b);
    }

    public void writeByte(int adr, int writeValue) throws TransmissionFailedException {
        this.writeByte(adr, writeValue, this.getStandardTimeOut());
    }

    public void writeWord(int adr, int writeValue) throws TransmissionFailedException {
        this.writeByte(adr, writeValue & 0xFF);
        this.writeByte(adr + 1, writeValue >> 8 & 0xFF);
    }

    public void writeDoubleWord(int adr, int writeValue) throws TransmissionFailedException {
        this.writeWord(adr, writeValue & 0xFFFF);
        this.writeWord(adr + 2, writeValue >>> 16 & 0xFFFF);
    }

    protected void writeByte(int adr, int writeValue, int timeout) throws TransmissionFailedException {
        this.fLastAddress = adr;
        int MAX_RETRY = 5;
        int currentTry = 0;
        try {
            if (this.fInputStream != null && this.fOutputStream != null) {
                int readValue;
                do {
                    this.resetInternal();
                    this.writeToOutputStream(1);
                    this.writeCommandAddress(adr);
                    this.writeToOutputStream(writeValue);
                    readValue = this.readInternalByte(timeout);
                    if (readValue != 6) continue;
                    ++this.fByteCount;
                    this.checkListener();
                    readValue = this.readNoWait();
                    if (readValue == 8) {
                        new LogoError(null, Language.getString("error.com.transferFailedCopyToSDCard", "Failed to copy program to SD card. \nPlease check:\n-SD card is inserted\n-SD card is not write-protected\n-SD card is not full", 1)).display();
                    }
                    return;
                } while (++currentTry < MAX_RETRY);
                if (readValue == 21) {
                    readValue = this.readNoWait();
                }
                throw new TransmissionFailedException(readValue);
            }
            throw new TransmissionFailedException(255);
        }
        catch (IOException ioe) {
            System.err.println("Write to outputStream failed");
            throw new TransmissionFailedException(255);
        }
    }

    public void writeNextByte(int value) throws TransmissionFailedException {
        this.nextAddress();
        this.writeByte(this.fLastAddress, value);
    }

    protected void writeBytes(int adr, int[] writeValue) throws TransmissionFailedException {
        if (this.fDebugComm) {
            System.out.println("array write: " + System.currentTimeMillis() + " " + Integer.toHexString(adr) + ", " + callReadTime++ + ", " + writeValue.length);
        }
        int checksum = 0;
        try {
            if (this.fInputStream != null && this.fOutputStream != null) {
                this.resetInternal();
                this.writeToOutputStream(4);
                int readValue = this.noAckInBlockMode() ? 6 : this.readInternalByte();
                if (readValue == 6) {
                    this.writeCommandAddress(adr);
                    this.writeToOutputStream((writeValue.length & 0xFF00) >> 8);
                    this.writeToOutputStream(writeValue.length & 0xFF);
                    for (int i = 0; i < writeValue.length; ++i) {
                        checksum ^= writeValue[i];
                        this.writeToOutputStream(writeValue[i]);
                        if (!this.isCheckPointOfWritingBytes(i) || (readValue = this.readNoWait()) == -1) continue;
                        if (readValue == 21) {
                            throw new TransmissionFailedException(this.readNoWait());
                        }
                        this.resetInternal();
                        throw new TransmissionFailedException(254);
                    }
                    this.writeToOutputStream((byte)checksum);
                    readValue = this.readInternalByte();
                    if (readValue == 6) {
                        return;
                    }
                    if (readValue == 21) {
                        readValue = this.readNoWait();
                    }
                    throw new TransmissionFailedException(readValue);
                }
                if (readValue == 21) {
                    readValue = this.readNoWait();
                }
                throw new TransmissionFailedException(readValue);
            }
            throw new TransmissionFailedException(255);
        }
        catch (IOException ioe) {
            throw new TransmissionFailedException(255);
        }
    }

    protected boolean isCheckPointOfWritingBytes(int index) {
        return false;
    }

    public void writeByteArray(int adr, int[] byteArray) throws TransmissionFailedException {
        if (byteArray.length > 0) {
            if (this.fBlockMode) {
                this.fByteCount += byteArray.length / 2;
                this.checkListener();
                this.writeBytes(adr, byteArray);
                this.fByteCount += byteArray.length / 2;
                this.checkListener();
            } else {
                this.writeByte(adr, byteArray[0]);
                for (int i = 1; i < byteArray.length; ++i) {
                    this.writeNextByte(byteArray[i]);
                }
            }
        }
    }

    public void setBlockMode(boolean newMode) {
        this.fBlockMode = newMode;
    }

    protected void writeCommandAddress(int adr) throws IOException {
        if (this.isAddress32()) {
            this.writeToOutputStream(this.getAddress(adr, 3));
            this.writeToOutputStream(this.getAddress(adr, 2));
        }
        this.writeToOutputStream(this.getAddress(adr, 1));
        this.writeToOutputStream(this.getAddress(adr, 0));
    }

    protected boolean checkCommandAddressFeedback(int adr) throws TransmissionFailedException {
        if (this.isAddress32()) {
            if (this.readInternalByte() != this.getAddress(adr, 3)) {
                return false;
            }
            if (this.readInternalByte() != this.getAddress(adr, 2)) {
                return false;
            }
        }
        if (this.readInternalByte() != this.getAddress(adr, 1)) {
            return false;
        }
        return this.readInternalByte() == this.getAddress(adr, 0);
    }

    protected boolean isAddress32() {
        return this.fAddressMode32;
    }

    private int getAddress(int address, int index) {
        int ret = (255 << index * 8 & address) >> index * 8;
        if (ret < 0) {
            ret += 256;
        }
        return ret;
    }

    protected void writeToOutputStream(int value) throws IOException {
        if (this.fDebugComm) {
            this.logOutput(value);
        }
        try {
            this.fOutputStream.write(value);
        }
        catch (IOException e) {
            if (e.getMessage().equals("Input/output error in writeByte")) {
                this.disablePortByNullPoint(e.getMessage());
            }
            throw e;
        }
        catch (NullPointerException e1) {
            System.out.println("Port not available");
            throw new IOException("PortInvalid");
        }
    }

    protected void disablePortByNullPoint(String errMessage) {
        if (errMessage.equals("Input/output error in writeByte") || errMessage.equals("No error in nativeavailable")) {
            System.err.println("Exit program by null pointer.");
            this.fInputStream = null;
            this.fOutputStream = null;
        }
    }

    public void reset() {
        this.resetInternal();
        this.fActTelePosition = 0;
        this.fMaxTelePosition = 0;
        this.fByteCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetInternal() {
        int readValue = 0;
        long start = System.currentTimeMillis();
        try {
            readValue = this.readInternalByteWithTimeout(0);
            if (this.fDebugGeneral && readValue != -1) {
                System.out.print("\nreset internal called: ");
            }
            while (readValue != -1) {
                if (this.fDebugGeneral) {
                    System.out.print(Integer.toHexString(readValue & 0xFF).toUpperCase() + " ");
                }
                readValue = this.readInternalByteWithTimeout(0);
            }
            if (this.fDebugComm) {
                System.out.println();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (this.fDebugComm) {
                System.out.println("DataTransfer.resetInternal() took " + (System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    private void logInput(int telegram) {
        String s = Integer.toHexString(telegram & 0xFF).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        this.lastActionTime = 0L;
        if (this.fDebugComm) {
            System.out.println(LOG_DIRECTION_IN + s + " " + System.currentTimeMillis());
        }
    }

    private void logOutput(int value) {
        String s = Integer.toHexString(value & 0xFF).toUpperCase();
        if (s.length() == 1) {
            s = "0" + s;
        }
        if (this.fDebugComm) {
            long nowTime = System.currentTimeMillis();
            if (this.lastActionTime != 0L) {
                if (nowTime - this.lastActionTime > 1000L) {
                    System.out.println("*********************************");
                } else if (nowTime - this.lastActionTime > 150L) {
                    System.out.println("---------------------------------");
                }
            }
            this.lastActionTime = nowTime;
            System.out.println(LOG_DIRECTION_OUT + s + " " + nowTime);
        }
    }

    public void addProgressListener(ProgressListener listener) {
        this.fProgressListener = listener;
    }

    public ProgressListener getProgressListener() {
        return this.fProgressListener;
    }

    protected void checkListener() {
        if (this.fProgressListener != null) {
            this.fProgressListener.setValue(this.fByteCount);
        }
    }

    protected void setShowErrorDialog(boolean showErrorDialog) {
        this.fShowErrorDialog = showErrorDialog;
    }

    public int[] getRemoteIOStatus() throws TransmissionFailedException {
        if (this.sendStateCommand(25)) {
            this.readInternalByte();
            this.readInternalByte();
            int[] ret = new int[this.getIOAreaLength()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.readInternalByte();
            }
            return ret;
        }
        if (this.fDebugGeneral) {
            System.out.println("DataTransfer.getRemoteIOStatus() error.");
        }
        return null;
    }

    public int getIOAreaLength() {
        return 67;
    }

    public int getDeviceState() throws TransmissionFailedException {
        if (this.sendStateCommand(23)) {
            return this.readInternalByte();
        }
        if (this.fDebugGeneral) {
            System.out.println("DataTransfer.getDeviceState() error.");
        }
        return -1;
    }

    public boolean sendCommand(int command) throws TransmissionFailedException {
        if (this.sendBytesAndWaitACK(new int[]{command})) {
            return this.readNoWait() == command;
        }
        throw new TransmissionFailedException(254);
    }

    public boolean sendStateCommand(int command) throws TransmissionFailedException {
        if (this.sendBytesAndWaitACK(new int[]{85, command, command, 170})) {
            if (command == 24 || command == 18) {
                int supports = -1;
                supports = command == 24 ? 1 : 2;
                this.waitUntilDeviceReady(3, supports, false);
            }
            return true;
        }
        throw new TransmissionFailedException(254);
    }

    public void waitUntilDeviceReady(int maxRetry, int supportedState, boolean showProgressListener) {
        if (showProgressListener && this.fProgressListener != null) {
            this.fProgressListener.setMaximum(maxRetry);
        }
        for (int i = 0; i < maxRetry; ++i) {
            block6: {
                try {
                    if ((supportedState & this.getDeviceState()) != 0) {
                        if (!this.fDebugGeneral) break;
                        System.out.println("The device is ready now.");
                        break;
                    }
                    Thread.sleep(1000L);
                    this.resetInternal();
                }
                catch (Exception e) {
                    if (!this.fDebugGeneral) break block6;
                    System.out.println("Exception cause by device status changes.");
                }
            }
            if (!showProgressListener || this.fProgressListener == null) continue;
            this.fProgressListener.setValue(i + 1);
        }
        if (showProgressListener && this.fProgressListener != null) {
            this.fProgressListener.setValue(maxRetry);
        }
    }

    public void writeCommandByte(int address, int value, int timeout) throws TransmissionFailedException {
        int newAddress = this.isAddress32() ? address & 0xFFFF | 0xFF0000 : address;
        this.writeByte(newAddress, value, timeout);
    }

    protected boolean noAckInBlockMode() {
        if (this.fRemoteHardware == null) {
            return false;
        }
        return this.fRemoteHardware.supports("commBlockModeWithoutAck");
    }

    protected boolean sendBytesAndWaitACK(int[] bytesToSend) throws TransmissionFailedException {
        try {
            this.resetInternal();
            for (int i = 0; i < bytesToSend.length; ++i) {
                this.writeToOutputStream(bytesToSend[i]);
            }
            int response = this.readInternalByte();
            if (response == 6) {
                return true;
            }
            if (response == 21) {
                throw new TransmissionFailedException(this.readNoWait());
            }
            throw new TransmissionFailedException(254);
        }
        catch (IOException exception) {
            throw new TransmissionFailedException(254);
        }
    }

    public boolean sendProgramLineRequest(int[] requestedProgramLines) throws TransmissionFailedException {
        try {
            for (int j = 0; j < 5; ++j) {
                if (this.fDebugComm) {
                    System.out.println("sendProgramLineRequest: " + (System.currentTimeMillis() - this.fLastSimulationTelegramReadTime) + "seit letztem Lesen eines Simulationstelegramms.");
                    System.out.println("Versuch: " + j);
                }
                this.resetInternal();
                this.writeToOutputStream(85);
                this.writeToOutputStream(19);
                this.writeToOutputStream(19);
                if (this.getHardware().supports("SupportMessageOnlineTest")) {
                    this.writeToOutputStream(OnlineTestTool.isMsgOnlineTestEnabled() ? 1 : 0);
                }
                this.writeToOutputStream(requestedProgramLines.length);
                for (int i = 0; i < requestedProgramLines.length; ++i) {
                    this.writeProgramLine(requestedProgramLines[i]);
                }
                this.writeToOutputStream(170);
                int response = this.readInternalByte();
                if (response == 6) {
                    return true;
                }
                if (response != 21) continue;
                int errorByte = this.readInternalByte();
                this.resetInternal();
                throw new TransmissionFailedException(errorByte);
            }
            throw new TransmissionFailedException(254);
        }
        catch (IOException exception) {
            throw new TransmissionFailedException(254);
        }
    }

    private void writeProgramLine(int progNr) throws IOException {
        if (this.fRemoteHardware != null && this.fRemoteHardware.getMaxResource(0) > 255) {
            this.writeToOutputStream(progNr & 0xFF);
            this.writeToOutputStream(progNr >> 8 & 0xFF);
        } else {
            this.writeToOutputStream(progNr);
        }
    }

    public int[] readSimulationTelegram(boolean writeAcknowledge, int[] commandType) throws TransmissionFailedException {
        if (this.fDebugComm) {
            System.out.println("Start: Simulationstelegramm lesen... Zeit set letztem Lesen:" + (System.currentTimeMillis() - this.fLastSimulationTelegramReadTime));
        }
        int timeout = 1000;
        boolean success = false;
        int[] buffer = null;
        long startTime = System.currentTimeMillis();
        while (!success && System.currentTimeMillis() - startTime < 1000L) {
            try {
                int commandByte2;
                int startByte = this.readInternalByte();
                if (startByte != 85) {
                    this.writeToOutputStream(21);
                    this.resetInternal();
                    continue;
                }
                int commandByte1 = this.readInternalByte();
                if (commandByte1 != (commandByte2 = this.readInternalByte()) || commandByte1 != 17 && commandByte1 != 26) {
                    this.writeToOutputStream(21);
                    this.resetInternal();
                    continue;
                }
                commandType[0] = commandByte1;
                int telegramLengthLow = this.readInternalByte();
                int telegramLengthHigh = this.readInternalByte();
                int telegramLength = telegramLengthLow + (telegramLengthHigh << 8);
                buffer = new int[telegramLength];
                for (int i = 0; i < telegramLength && System.currentTimeMillis() - startTime <= 1000L; ++i) {
                    buffer[i] = this.readInternalByte();
                }
                int stopByte = this.readInternalByte();
                if (stopByte != 170) {
                    this.writeToOutputStream(21);
                    if (this.fDebugGeneral) {
                        System.out.println("TRANSMISION FAILED: readSimulationTelegram took: " + (System.currentTimeMillis() - startTime));
                    }
                    throw new TransmissionFailedException(254);
                }
                if (writeAcknowledge && commandByte1 == 17) {
                    this.writeToOutputStream(6);
                }
                success = true;
            }
            catch (IOException ioexception) {}
        }
        if (success) {
            if (this.fDebugComm) {
                System.out.println("readSimulationTelegram took: " + (System.currentTimeMillis() - startTime));
            }
            this.fLastSimulationTelegramReadTime = System.currentTimeMillis();
            return buffer;
        }
        if (this.fDebugComm) {
            System.out.println("readSimulationTelegram took: " + (System.currentTimeMillis() - startTime));
        }
        throw new TransmissionFailedException(254);
    }

    public void confirmRemoteParamChange() {
        try {
            this.writeToOutputStream(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getErrorString(int errorCode) {
        switch (errorCode) {
            case 1: {
                return Language.getString("error.com.busy", "Hardware is busy");
            }
            case 241: {
                return Language.getString("error.com.checksum", "Checksummerror");
            }
            case 243: {
                return Language.getString("error.com.wrongAdrInHeader", "Wrong adress in result-header");
            }
            case 3: {
                return Language.getString("error.com.illegalAccess", "Illegal Access");
            }
            case 128: {
                return Language.getString("error.com.internal", "Intenal error on hardware");
            }
            case 242: {
                return Language.getString("error.com.noBlocktitleRead", "Wrong blocktitle in read-result");
            }
            case 255: {
                return Language.getString("error.com.noStream", "Connection interrupted");
            }
            case 4: {
                return Language.getString("error.com.parity", "Parity, Overrun or Framing error");
            }
            case 7: {
                return Language.getString("error.com.sim", "Simulationerror");
            }
            case 244: {
                return Language.getString("error.com.timeoutNoRespond", "Read timeout");
            }
            case 2: {
                return Language.getString("error.com.timeoutSend", "Send Timeout");
            }
            case 5: {
                return Language.getString("error.com.unknownCommand", "Unknown Command");
            }
            case 6: {
                return Language.getString("error.com.xorNotOk", "XOR-Sum not OK");
            }
            case 240: {
                return Language.getString("error.com.rcvBufferEmpty", "Receivebuffer empty");
            }
            case 176: {
                String portName = LogoProperties.instance().getProperty("port", "COM2");
                return portName + Language.getString("error.com.portNotAvailable", "%-Port not available!");
            }
        }
        return Language.getString("error.com.unknown", "Unknown error");
    }

    public boolean sendParamChangeRequest(int[] bytes) {
        int retryTime = 5;
        try {
            for (int times = 0; times < 5; ++times) {
                this.resetInternal();
                this.writeToOutputStream(85);
                this.writeToOutputStream(26);
                this.writeToOutputStream(26);
                int length = bytes[0] + bytes[1] * 256;
                for (int i = 0; i < length + 2; ++i) {
                    this.writeToOutputStream(bytes[i]);
                }
                this.writeToOutputStream(170);
                int response = this.readInternalByte();
                if (response == 6) {
                    return true;
                }
                if (response != 21) continue;
                if (this.readInternalByte() == 3) {
                    new LogoError(null, "error.com.illegalMode", "The Base Module is in the parameter assignment mode. Please retry after exiting this mode.").display();
                }
                this.resetInternal();
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean sendDiagnosticClearRequest(int[] diagnData) {
        int retryTime = 5;
        try {
            for (int times = 0; times < 5; ++times) {
                this.resetInternal();
                this.writeToOutputStream(85);
                this.writeToOutputStream(28);
                this.writeToOutputStream(28);
                for (int i = 0; i < diagnData.length; ++i) {
                    this.writeToOutputStream(diagnData[i]);
                }
                this.writeToOutputStream(170);
                int response = this.readInternalByte();
                if (response == 6) {
                    return true;
                }
                if (response != 21) continue;
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            new LogoError(null, Language.getString("extra.transfer.diagnostic.transmissionFail", "Transmission failed, please check your network connection.")).display();
            return false;
        }
    }

    public void sendDataTableRequest(boolean command, int[] Items) {
        boolean retryTime = true;
        int readOrWrite = command ? 29 : 30;
        try {
            for (int times = 0; times < 1; ++times) {
                this.resetInternal();
                this.writeToOutputStream(85);
                this.writeToOutputStream(readOrWrite);
                this.writeToOutputStream(readOrWrite);
                for (int i = 0; i < Items.length; ++i) {
                    this.writeToOutputStream(Items[i]);
                }
                this.writeToOutputStream(170);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setIPConfig(int startAddress, CommunicationSettingPanel.IPConfig config) throws TransmissionFailedException {
        int ip = IPV4Utils.getInstance().formatToInt(config.values[1]);
        int mask = IPV4Utils.getInstance().formatToInt(config.values[2]);
        int gate = IPV4Utils.getInstance().formatToInt(config.values[3]);
        this.writeDoubleWord(startAddress, ip);
        this.writeByte(startAddress + 4, ~this.getChecksum(ip) & 0xFF);
        this.writeDoubleWord(startAddress + 5, mask);
        this.writeByte(startAddress + 9, ~this.getChecksum(mask) & 0xFF);
        this.writeDoubleWord(startAddress + 10, gate);
        this.writeByte(startAddress + 14, ~this.getChecksum(gate) & 0xFF);
    }

    private byte getChecksum(int value) {
        byte checksum = 0;
        for (int i = 0; i < 4; ++i) {
            checksum = (byte)(checksum + (value >> i * 8 & 0xFF));
        }
        return checksum;
    }

    public CommunicationSettingPanel.IPConfig getIPConfig(int startAddress) throws TransmissionFailedException {
        int[] data = this.readByteArray(startAddress, 14);
        int ip = Util.makeSignedDoubleWord(data[3], data[2], data[1], data[0]);
        int mask = Util.makeSignedDoubleWord(data[8], data[7], data[6], data[5]);
        int gate = Util.makeSignedDoubleWord(data[13], data[12], data[11], data[10]);
        CommunicationSettingPanel.IPConfig config = new CommunicationSettingPanel.IPConfig();
        config.values[1] = IPV4Utils.getInstance().formatToString(ip);
        config.values[2] = IPV4Utils.getInstance().formatToString(mask);
        config.values[3] = IPV4Utils.getInstance().formatToString(gate);
        return config;
    }

    public abstract void rebuildConnection() throws ExceptionAlreadyHandledException;

    public int getStandardTimeOut() {
        return 1001;
    }
}

